# --------------------------
# --------------------------
# Figure 1: Archetype comparison
# --------------------------
# --------------------------

rootDirectory = '' # YOU must set this!

rdaInputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figure 1 - Archetype comparison/RDA', sep = '')
figureOutputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figure 1 - Archetype comparison', sep = '')
functionDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Functions', sep = '')
source(paste(functionDirectory,'callFunctions.R', sep = ''))
callFunctions(functionDirectory)

library(raster)
library(fields)

setwd(rdaInputDirectory)
load('Archetype_grids.rda')
load('Archetype_trials.rda')

tf = dim(output)[1]
time = 1:tf
n_runs = dim(output)[2]
n_matrices = dim(output)[3]

# ------------------------
# Define plot colors
set.seed(1234)
disturbanceSeq = exp(runif(n = n_runs, min = log(0.25),max = log(2.5)))
disturbColSeq = exp(seq(log(0.25),log(2.5), length.out = 1000))
col = colorRampPalette(c('black','darkred','pink',grey(0.7)))(1000)

# ------------------------
# Main figure panels
setwd(figureOutputDirectory)
tiff('Figure1_mainPanels.tif', width = 700*3, height = 700*3, res = 300)
par(mfrow = c(3,1))
for(i_Mi in 1:3){
  for(i_run in 1:n_runs){
    colIndex = which.min(abs(disturbanceSeq[i_run] - disturbColSeq))
    if(i_run == 1 & i_Mi == 1){
      par(mar = c(0.2,5,5,3))
      plot(output[,i_run,i_Mi] ~ time, type = 'l',
           log = 'x', xaxt = 'n', yaxt = 'n',cex.lab = 1.6, cex.axis = 1.5,
           ylab = '',
           xlab = 'Time steps',
           ylim = c(0,1), xlim = c(1,tf),
           col = col[colIndex]) 
      axis(side = 2, at = seq(0,1,0.25), labels = seq(0, 100, 25), cex.axis = 1.5)
    } else if(i_run == 1 & i_Mi == 2){
      par(mar = c(2.4,5,2.4,3))
      plot(output[,i_run,i_Mi] ~ time, type = 'l',
           log = 'x', xaxt= 'n', yaxt= 'n', cex.lab = 1.6, cex.axis = 1.5,
           ylab = 'Vegetation cover (%)',
           xlab = 'Time steps',
           ylim = c(0,1), xlim = c(1,tf),
           col = col[colIndex])  
      axis(side = 2, at = seq(0,1,0.25), labels = seq(0, 100, 25), cex.axis = 1.5)
    } else if(i_run == 1 & i_Mi == 3){
      par(mar = c(5,5,0.2,3))
      plot(output[,i_run,i_Mi] ~ time, type = 'l',
           log = 'x', yaxt= 'n', cex.lab = 1.6, cex.axis = 1.5,
           ylab = '',
           xlab = 'Time steps',
           ylim = c(0,1), xlim = c(1,tf),
           col = col[colIndex])
      axis(side = 2, at = seq(0,1,0.25), labels = seq(0, 100, 25), cex.axis = 1.5)
    } else {
      lines(output[,i_run,i_Mi] ~ time, col = alpha(col[colIndex]),0.1, lwd = 1)
    }
  }
  # Average success line
  lines(rowMeans(output[,,i_Mi]) ~ time, lwd = 3)
}
par(mfrow = c(1,1))
dev.off()

# ------------------------
# Legend
setwd(figureOutputDirectory)
tiff('Figure1_legend.tif', width = 700*3, height = 700*3, res = 300)
plot(c(1), xlim = c(0,1), ylim = c(0,1), type = 'n', bty = 'n', yaxt = 'n', xaxt = 'n', ylab = '', xlab = '')
fields::colorbar.plot(x = 0.5, y = 0.5, 
              strip.length = 0.62, strip.width = 0.05,
              strip = log(disturbColSeq), col = rev(col), horizontal = T)
lines(x = c(0.2, 0.2), y = c(0.525, 0.54), lwd = 2)
lines(x = c(0.35, 0.35), y = c(0.525, 0.54), lwd = 2)
lines(x = c(0.5, 0.5), y = c(0.525, 0.54), lwd = 2)
lines(x = c(0.65, 0.65), y = c(0.525, 0.54), lwd = 2)
lines(x = c(0.8, 0.8), y = c(0.525, 0.54), lwd = 2)
text(x = seq(0.2,0.8, length.out = 5), y = 0.58, rev(c(0.3,0.125,0.025,0.002,0.00002)), cex = 1)
rect(xright = 0.2, xleft = 0.8, ytop = 0.525, ybottom =  0.475, lwd = 2)
text(y = 0.44, x= 0.5, 'Average disturbance intensity')
dev.off()


# -----
# Archetype subpanels
setwd(figureOutputDirectory)
tiff('Figure1_subpanel1.tif', width = 20, height = 20, units = 'cm', res = 300)
plot(raster::raster(MiSeries[,,1]), box = F, axes = F, legend = F)
dev.off()

tiff('Figure1_subpanel2.tif',  width = 20, height = 20, units = 'cm', res = 300)
plot(raster::raster(MiSeries[,,2]), box = F, axes = F, legend = F)
dev.off()

tiff('Figure1_subpanel3.tif',  width = 20, height = 20, units = 'cm', res = 300)
plot(raster::raster(MiSeries[,,3]), box = F, axes = F, legend = F)
dev.off()

# -----
# Print minimum colonization period for each of the three archetypes (in-text)
for(i_matrix in 1:3){
  colonizationInterval = rep(NA, times = n_runs)
  for(i_run in 1:n_runs){
    if(output[tf,i_run,i_matrix] == 1){
      colonizationInterval[i_run] = min(which(output[,i_run,i_matrix] == 1))
    }
  }
  colonizationInterval = colonizationInterval[!is.na(colonizationInterval)]
  print(min(colonizationInterval))
}
